package org.msh.tb.bd.tbforms.indicator.detailed;

import org.msh.tb.cases.CaseItemData;
import org.msh.tb.entities.Workspace;
import org.msh.tb.indicators.core.IndicatorFilters;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.msh.tb.bd.tbforms.indicator.detailed.TBFormCasesQueryUtils.getHQLWhere;
import static org.msh.tb.bd.tbforms.indicator.detailed.TBFormCasesQueryUtils.parseResult;

public class TBFormCasesQuery {

    private Workspace defaultWorkspace;
    private IndicatorFilters indicatorFilters;
    private String cellCondition;
    private EntityManager entityManager;

    // parameters used to build the query
    private Map<String, Object> queryParams;

    public TBFormCasesQuery(Workspace defaultWorkspace, IndicatorFilters indicatorFilters, String cellCondition, EntityManager entityManager) {
        this.defaultWorkspace = defaultWorkspace;
        this.indicatorFilters = indicatorFilters;
        this.cellCondition = cellCondition;
        this.entityManager = entityManager;
    }

    /**
     * Load the CaseItemData list into result variable
     */
    public List<CaseItemData> getResult(int page, int limit) {
        // initialize query params
        queryParams = new HashMap<String, Object>();

        // create HQL
        String queryStr = ("select c.id, p.name, p.recordNumber, c.caseNumber, p.gender " +
                "from TbCaseBD c join c.patient p ")
                .concat(getJoinHQL()).concat(" ")
                .concat(getHQLWhere(indicatorFilters, defaultWorkspace, queryParams, cellCondition)).concat(" ")
                .concat(getSpecificConditions()).concat(" ")
                .concat("order by p.name");

        // instantiate Query
        Query query = entityManager.createQuery(queryStr);

        // Set Query parameters
        for (String k : queryParams.keySet()) {
            query.setParameter(k, queryParams.get(k));
        }

        // Set pagination Parameters
        query.setFirstResult(getFirstResult(page, limit));
        query.setMaxResults(limit);

        // Query result and parse it
        return parseResult(query.getResultList());
    }

    /**
     * Load the resultCount value, representing the total count of that query
     */
    public Long getResultCount() {
        // initialize query params
        queryParams = new HashMap<String, Object>();

        // create HQL
        String queryStr = ("select count(*) from TbCaseBD c join c.patient p ")
                .concat(getJoinHQL()).concat(" ")
                .concat(getHQLWhere(indicatorFilters, defaultWorkspace, queryParams, cellCondition)).concat(" ")
                .concat(getSpecificConditions()).concat(" ")
                .concat("order by p.name");

        // instantiate Query
        Query query = entityManager.createQuery(queryStr);

        // Set Query parameters
        for (String k : queryParams.keySet()) {
            query.setParameter(k, queryParams.get(k));
        }

        return (Long) query.getSingleResult();
    }

    protected String getJoinHQL() {
        return "";
    }

    protected String getSpecificConditions() {
        return "";
    }

    protected TBFormCasesQuery addQueryParam(String paramId, Object param) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, Object>();
        }
        queryParams.put(paramId, param);
        return this;
    }

    /**
     * @return The first count result of the current pagination to be set on the query
     */
    private Integer getFirstResult(int page, int limit) {
        return page == 0 ? 0 : page * limit;
    }

}
